library(tidyverse)
library(here)
library(fs)
library(readxl)
library(janitor)

#Read in the sectioned casts
data_sectioned <- tibble(files = fs::dir_ls(here("C:/Users/katey/Desktop/2021_wk_auto_ctd_sn7783/data/02_section")))  %>% #created a list of files to be imported
  mutate(data = pmap(list(files),
                     ~ read_tsv(..1, col_names = FALSE))) %>% #imported the files
  mutate(data = pmap(list(files, data), 
                     ~ mutate(..2, source_file = as.character(..1)))) %>% #added file name to each row in each file
  select(data) %>%
  map_df(bind_rows) #joined all tables in filtered_data into one

#Subset rows containing conductivity
data_conductivity <- data_sectioned %>% filter(grepl("# span 5 =", X1)) #kept rows containing span 5 (conductivity)

#Split the data column
data_conductivity <- separate(data = data_conductivity, col = X1,  sep = " +", into = c("a","b","c","d","e","f")) #split data column into several columns
data_conductivity <- data_conductivity %>% mutate(e = str_remove_all(e, ",")) #removed commas from start scan column
data_conductivity <- data_conductivity %>% select(c("e", "f", "source_file")) #subset needed columns

#Make the columns numeric
data_conductivity <- data_conductivity %>% mutate(cond_min = as.numeric(e))
data_conductivity <- data_conductivity %>% mutate(cond_max = as.numeric(f))
data_conductivity <- data_conductivity %>% select(c("source_file", "cond_min", "cond_max"))

#Subset fresh casts
fresh_casts <- data_conductivity %>% filter(if_any(where(is.numeric), ~ .x <=6))